/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.javasound;

import com.sun.j3d.audioengines.AudioEngine3D;
import com.sun.j3d.audioengines.AudioEngine3DL2;
import com.sun.j3d.audioengines.AudioEngineThread;
import com.sun.j3d.audioengines.javasound.JSAuralParameters;
import com.sun.j3d.audioengines.javasound.JSSample;

class JSThread
extends AudioEngineThread {
    int totalChannels = 0;
    boolean rampGain = false;
    boolean rampRate = false;
    AudioEngine3D audioEngine = null;

    JSThread(ThreadGroup threadGroup, AudioEngine3DL2 audioEngine3DL2) {
        super(threadGroup, "J3D-JavaSoundThread");
        this.audioEngine = audioEngine3DL2;
        this.totalChannels = 32;
    }

    public synchronized void doWork() {
        int n2 = this.audioEngine.getSampleListSize();
        JSSample jSSample = null;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            jSSample = (JSSample)this.audioEngine.getSample(i2);
            if (jSSample == null || !jSSample.getRampRateFlag()) continue;
            boolean bl = this.adjustRate(jSSample);
            jSSample.setRampRateFlag(!bl);
            if (bl) continue;
            ++n3;
        }
        if (n3 > 0) {
            this.rampRate = true;
            this.runMonitor(2, 0L, null);
        } else {
            this.rampRate = false;
        }
    }

    int getTotalChannels() {
        return this.totalChannels;
    }

    boolean adjustRate(JSSample jSSample) {
        double d2 = 0.00130213;
        double d3 = 0.00260417;
        double d4 = jSSample.getCurrentRateRatio();
        double d5 = jSSample.getTargetRateRatio();
        boolean bl = false;
        if (d4 > 0.0) {
            double d6 = d5;
            double d7 = 0.0;
            d7 = d5 - d4;
            if (d7 > 0.0) {
                if (d7 >= d3) {
                    d6 = d4 + d3;
                    bl = false;
                } else {
                    d6 = d5;
                    bl = true;
                }
            } else if (d7 < 0.0) {
                if (-d7 >= d2) {
                    d6 = d4 - d2;
                    bl = false;
                } else {
                    d6 = d5;
                    bl = true;
                }
            } else {
                return true;
            }
            this.setSampleRate(jSSample, (float)d6);
        } else {
            this.setSampleRate(jSSample, (float)d5);
            bl = false;
        }
        return bl;
    }

    void setSampleRate(JSSample jSSample, JSAuralParameters jSAuralParameters) {
    }

    void setSampleGain(JSSample jSSample, JSAuralParameters jSAuralParameters) {
    }

    void setSampleDelay(JSSample jSSample, JSAuralParameters jSAuralParameters) {
    }

    void setTargetGain(JSSample jSSample, float f2) {
    }

    void setRate(JSSample jSSample, float f2) {
        this.setSampleRate(jSSample, f2);
        jSSample.setRampRateFlag(false);
    }

    void setTargetRate(JSSample jSSample, float f2) {
        jSSample.setRampRateFlag(true);
        jSSample.setTargetRateRatio(f2);
        this.rampRate = true;
        this.runMonitor(2, 0L, null);
    }

    void setSampleGain(JSSample jSSample, float f2) {
    }

    void setSampleRate(JSSample jSSample, float f2) {
        jSSample.setCurrentRateRatio(f2);
    }

    boolean startSample(JSSample jSSample) {
        return true;
    }

    boolean stopSample(JSSample jSSample) {
        return true;
    }

    void pauseSample(JSSample jSSample) {
    }

    void unpauseSample(JSSample jSSample) {
    }

    void muteSample(JSSample jSSample) {
    }

    void unmuteSample(JSSample jSSample) {
    }

    int startStreams() {
        return 0;
    }

    int startStream() {
        return 0;
    }

    int startClips() {
        return 0;
    }

    int startClip() {
        return 0;
    }

    public void initialize() {
        super.initialize();
    }

    boolean close() {
        return false;
    }

    public void shutdown() {
    }

    public void cleanup() {
        super.cleanup();
    }
}

